/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;

public class HttpUtils {
    private static final float[] MULTIPLIERS = new float[]{0.1f, 0.01f, 0.001f};

    public static String composeContentType(String contentType, String characterEncoding) {
        String newContentType;
        if (characterEncoding == null) {
            return contentType;
        }
        boolean hasCharset = false;
        int semicolonIndex = -1;
        int index2 = contentType.indexOf(59);
        while (index2 != -1) {
            int len = contentType.length();
            semicolonIndex = index2++;
            while (index2 < len && contentType.charAt(index2) == ' ') {
                ++index2;
            }
            if (index2 + 8 < len && contentType.charAt(index2) == 'c' && contentType.charAt(index2 + 1) == 'h' && contentType.charAt(index2 + 2) == 'a' && contentType.charAt(index2 + 3) == 'r' && contentType.charAt(index2 + 4) == 's' && contentType.charAt(index2 + 5) == 'e' && contentType.charAt(index2 + 6) == 't' && contentType.charAt(index2 + 7) == '=') {
                hasCharset = true;
                break;
            }
            index2 = contentType.indexOf(59, index2);
        }
        if (hasCharset) {
            newContentType = contentType.substring(0, semicolonIndex);
            String tail = contentType.substring(index2 + 8);
            int nextParam = tail.indexOf(59);
            if (nextParam != -1) {
                newContentType = newContentType + tail.substring(nextParam);
            }
        } else {
            newContentType = contentType;
        }
        StringBuilder sb = new StringBuilder(newContentType.length() + characterEncoding.length() + 9);
        return sb.append(newContentType).append(";charset=").append(characterEncoding).toString();
    }

    public static float convertQValueToFloat(DataChunk dc, int startIdx, int stopIdx) {
        float qvalue = 0.0f;
        DataChunk.Type type = dc.getType();
        try {
            switch (type) {
                case String: {
                    qvalue = HttpUtils.convertQValueToFloat(dc.toString(), startIdx, stopIdx);
                    break;
                }
                case Buffer: {
                    BufferChunk bc = dc.getBufferChunk();
                    int offs = bc.getStart();
                    qvalue = HttpUtils.convertQValueToFloat(bc.getBuffer(), offs + startIdx, offs + stopIdx);
                    break;
                }
                case Chars: {
                    CharChunk cc = dc.getCharChunk();
                    int offs = cc.getStart();
                    qvalue = HttpUtils.convertQValueToFloat(cc.getChars(), offs + startIdx, offs + stopIdx);
                }
            }
        }
        catch (Exception e) {
            qvalue = 0.0f;
        }
        return qvalue;
    }

    public static float convertQValueToFloat(Buffer buffer, int startIdx, int stopIdx) {
        float result2 = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i = 0; i < len; ++i) {
            char c = (char)buffer.get(i + startIdx);
            if (multIdx == -1) {
                if (firstDigitProcessed && c != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                if (c == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result2 += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (!(result2 > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                result2 += (float)Character.digit(c, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
        }
        return result2;
    }

    public static float convertQValueToFloat(String string2, int startIdx, int stopIdx) {
        float result2 = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i = 0; i < len; ++i) {
            char c = string2.charAt(i + startIdx);
            if (multIdx == -1) {
                if (firstDigitProcessed && c != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string2.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                if (c == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result2 += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (!(result2 > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string2.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string2.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                result2 += (float)Character.digit(c, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + new String(string2.toCharArray(), startIdx, stopIdx) + ", detected");
        }
        return result2;
    }

    public static float convertQValueToFloat(char[] chars, int startIdx, int stopIdx) {
        float result2 = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i = 0; i < len; ++i) {
            char c = chars[i + startIdx];
            if (multIdx == -1) {
                if (firstDigitProcessed && c != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                if (c == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result2 += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (!(result2 > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                result2 += (float)Character.digit(c, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
        }
        return result2;
    }

    public static int longToBuffer(long value2, byte[] buffer) {
        boolean negative;
        int i = buffer.length;
        if (value2 == 0L) {
            buffer[--i] = 48;
            return i;
        }
        int radix = 10;
        if (value2 < 0L) {
            negative = true;
            value2 = -value2;
        } else {
            negative = false;
        }
        do {
            int ch = 48 + (int)(value2 % 10L);
            buffer[--i] = (byte)ch;
        } while ((value2 /= 10L) != 0L);
        if (negative) {
            buffer[--i] = 45;
        }
        return i;
    }

    public static void longToBuffer(long value2, Buffer buffer) {
        boolean negative;
        if (value2 == 0L) {
            buffer.put(0, (byte)48);
            buffer.limit(1);
            return;
        }
        int radix = 10;
        if (value2 < 0L) {
            negative = true;
            value2 = -value2;
        } else {
            negative = false;
        }
        int position2 = buffer.limit();
        do {
            int ch = 48 + (int)(value2 % 10L);
            buffer.put(--position2, (byte)ch);
        } while ((value2 /= 10L) != 0L);
        if (negative) {
            buffer.put(--position2, (byte)45);
        }
        buffer.position(position2);
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result2 = new StringBuilder(content.length + 50);
        block6: for (char aContent : content) {
            switch (aContent) {
                case '<': {
                    result2.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result2.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result2.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result2.append("&quot;");
                    continue block6;
                }
                default: {
                    result2.append(aContent);
                }
            }
        }
        return result2.toString();
    }
}

